/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes;

import com.foopy.forgeskyboxes.SkyboxManager;
import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import com.foopy.forgeskyboxes.util.object.Conditions;
import com.foopy.forgeskyboxes.util.object.Decorations;
import com.foopy.forgeskyboxes.util.object.Properties;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class OverworldSkybox
extends AbstractSkybox {
    public static Codec<OverworldSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations)).apply((Applicative)instance, OverworldSkybox::new));

    public OverworldSkybox(Properties properties, Conditions conditions, Decorations decorations) {
        super(properties, conditions, decorations);
    }

    @Override
    public SkyboxType<? extends AbstractSkybox> getType() {
        return (SkyboxType)SkyboxType.MONO_COLOR_SKYBOX.get();
    }

    @Override
    public void render(WorldRendererAccess worldRendererAccess, PoseStack matrices, Matrix4f projectionMatrix, float tickDelta, Camera camera, boolean thickFog) {
        float[] fs;
        Minecraft client = Minecraft.m_91087_();
        ClientLevel world = client.f_91073_;
        assert (client.f_91073_ != null);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Vec3 vec3d = world.m_171660_(client.f_91063_.m_109153_().m_90583_(), tickDelta);
        float f = (float)vec3d.f_82479_;
        float g = (float)vec3d.f_82480_;
        float h = (float)vec3d.f_82481_;
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)this.alpha);
        ShaderInstance shaderProgram = RenderSystem.getShader();
        worldRendererAccess.getLightSkyBuffer().m_85921_();
        worldRendererAccess.getLightSkyBuffer().m_253207_(matrices.m_85850_().m_252922_(), projectionMatrix, shaderProgram);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        float skyAngle = world.m_46942_(tickDelta);
        float skyAngleRadian = world.m_46490_(tickDelta);
        if (SkyboxManager.getInstance().isEnabled() && SkyboxManager.getInstance().getActiveSkyboxes().stream().anyMatch(skybox -> {
            AbstractSkybox abstractSkybox;
            return skybox instanceof AbstractSkybox && (abstractSkybox = (AbstractSkybox)skybox).getDecorations().getRotation().getSkyboxRotation();
        })) {
            skyAngle = Mth.m_14091_((float)((float)world.m_46468_() / 24000.0f + 0.75f), (float)1.0f);
            skyAngleRadian = skyAngle * ((float)Math.PI * 2);
        }
        if ((fs = world.m_104583_().m_7518_(skyAngle, tickDelta)) != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.m_85836_();
            matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float i = Mth.m_14031_((float)skyAngleRadian) < 0.0f ? 180.0f : 0.0f;
            matrices.m_252781_(Axis.f_252403_.m_252977_(i));
            matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float j = fs[0];
            float k = fs[1];
            float l = fs[2];
            Matrix4f matrix4f = matrices.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(j, k, l, fs[3] * this.alpha).m_5752_();
            for (int n = 0; n <= 16; ++n) {
                float o = (float)n * ((float)Math.PI * 2) / 16.0f;
                float p = Mth.m_14031_((float)o);
                float q = Mth.m_14089_((float)o);
                bufferBuilder.m_252986_(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).m_85950_(fs[0], fs[1], fs[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            matrices.m_85849_();
        }
        this.renderDecorations(worldRendererAccess, matrices, projectionMatrix, tickDelta, bufferBuilder, this.alpha);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d = client.f_91074_.m_20299_((float)tickDelta).f_82480_ - world.m_6106_().m_171687_((LevelHeightAccessor)world);
        if (d < 0.0) {
            matrices.m_85836_();
            matrices.m_252880_(0.0f, 12.0f, 0.0f);
            worldRendererAccess.getDarkSkyBuffer().m_85921_();
            worldRendererAccess.getDarkSkyBuffer().m_253207_(matrices.m_85850_().m_252922_(), projectionMatrix, shaderProgram);
            VertexBuffer.m_85931_();
            matrices.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

