/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes;

import com.foopy.forgeskyboxes.FabricSkyBoxesClient;
import com.foopy.forgeskyboxes.api.skyboxes.FSBSkybox;
import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import com.foopy.forgeskyboxes.util.Utils;
import com.foopy.forgeskyboxes.util.object.Conditions;
import com.foopy.forgeskyboxes.util.object.Decorations;
import com.foopy.forgeskyboxes.util.object.Properties;
import com.foopy.forgeskyboxes.util.object.Weather;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AbstractSkybox
implements FSBSkybox {
    public transient float alpha;
    protected Properties properties = Properties.DEFAULT;
    protected Conditions conditions = Conditions.DEFAULT;
    protected Decorations decorations = Decorations.DEFAULT;
    private int lastTime = -2;
    private float conditionAlpha = 0.0f;

    protected AbstractSkybox() {
    }

    protected AbstractSkybox(Properties properties, Conditions conditions, Decorations decorations) {
        this.properties = properties;
        this.conditions = conditions;
        this.decorations = decorations;
    }

    @Override
    public void tick(ClientLevel ClientLevel2) {
        this.updateAlpha();
    }

    @Override
    public final float updateAlpha() {
        int currentTime = (int)(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46468_() % 24000L);
        boolean condition = this.checkConditions();
        float fadeAlpha = 1.0f;
        if (this.properties.getFade().isAlwaysOn()) {
            this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.getTransitionInDuration() : this.properties.getTransitionOutDuration(), condition);
        } else {
            fadeAlpha = Utils.calculateFadeAlphaValue(1.0f, 0.0f, currentTime, this.properties.getFade().getStartFadeIn(), this.properties.getFade().getEndFadeIn(), this.properties.getFade().getStartFadeOut(), this.properties.getFade().getEndFadeOut());
            this.conditionAlpha = this.lastTime == currentTime - 1 || this.lastTime == currentTime ? Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.getTransitionInDuration() : this.properties.getTransitionOutDuration(), condition) : Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, FabricSkyBoxesClient.config().generalSettings.unexpectedTransitionDuration, condition);
        }
        this.alpha = fadeAlpha * this.conditionAlpha * (this.properties.getMaxAlpha() - this.properties.getMinAlpha()) + this.properties.getMinAlpha();
        this.alpha = Mth.m_14036_((float)this.alpha, (float)this.properties.getMinAlpha(), (float)this.properties.getMaxAlpha());
        this.lastTime = currentTime;
        return this.alpha;
    }

    protected boolean checkConditions() {
        return this.checkDimensions() && this.checkWorlds() && this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffects() && this.checkLoop();
    }

    protected boolean checkBiomes() {
        Minecraft client = Minecraft.m_91087_();
        Objects.requireNonNull(client.f_91073_);
        Objects.requireNonNull(client.f_91074_);
        return this.conditions.getBiomes().isEmpty() || this.conditions.getBiomes().contains(client.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)client.f_91073_.m_204166_(client.f_91074_.m_20183_()).m_203334_())));
    }

    protected boolean checkDimensions() {
        Minecraft client = Minecraft.m_91087_();
        Objects.requireNonNull(client.f_91073_);
        return this.conditions.getDimensions().isEmpty() || this.conditions.getDimensions().contains(client.f_91073_.m_46472_().m_135782_());
    }

    protected boolean checkWorlds() {
        Minecraft client = Minecraft.m_91087_();
        Objects.requireNonNull(client.f_91073_);
        return this.conditions.getWorlds().isEmpty() || this.conditions.getWorlds().contains(client.f_91073_.m_6042_().f_63837_());
    }

    protected boolean checkEffects() {
        Minecraft client = Minecraft.m_91087_();
        Objects.requireNonNull(client.f_91073_);
        Camera camera = client.f_91063_.m_109153_();
        if (this.conditions.getEffects().isEmpty()) {
            LivingEntity livingEntity;
            boolean thickFog;
            boolean bl = thickFog = client.f_91073_.m_104583_().m_5781_(Mth.m_14143_((float)camera.m_90588_().m_123341_()), Mth.m_14143_((float)camera.m_90588_().m_123342_())) || client.f_91065_.m_93090_().m_93715_();
            if (thickFog) {
                return this.properties.isRenderInThickFog();
            }
            FogType fogType = camera.m_167685_();
            if (fogType == FogType.POWDER_SNOW || fogType == FogType.LAVA) {
                return false;
            }
            Entity entity = camera.m_90592_();
            return !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_) && !livingEntity.m_21023_(MobEffects.f_216964_);
        }
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.conditions.getEffects().stream().noneMatch(ResourceLocation2 -> client.f_91073_.m_9598_().m_175515_(Registries.f_256929_).m_7745_(ResourceLocation2) != null && livingEntity.m_21023_((MobEffect)client.f_91073_.m_9598_().m_175515_(Registries.f_256929_).m_7745_(ResourceLocation2)));
        }
        return true;
    }

    protected boolean checkXRanges() {
        double playerX = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_20185_();
        return Utils.checkRanges(playerX, this.conditions.getXRanges());
    }

    protected boolean checkYRanges() {
        double playerY = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_20186_();
        return Utils.checkRanges(playerY, this.conditions.getYRanges());
    }

    protected boolean checkZRanges() {
        double playerZ = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_20189_();
        return Utils.checkRanges(playerZ, this.conditions.getZRanges());
    }

    protected boolean checkLoop() {
        if (!this.conditions.getLoop().getRanges().isEmpty() && this.conditions.getLoop().getDays() > 0.0) {
            double currentTime;
            for (currentTime = (double)(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46468_() - (long)this.properties.getFade().getStartFadeIn()); currentTime < 0.0; currentTime += 24000.0 * this.conditions.getLoop().getDays()) {
            }
            double currentDay = currentTime / 24000.0 % this.conditions.getLoop().getDays();
            return Utils.checkRanges(currentDay, this.conditions.getLoop().getRanges());
        }
        return true;
    }

    protected boolean checkWeather() {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Biome.Precipitation precipitation = ((Biome)level.m_204166_(player.m_20183_()).m_203334_()).m_264600_(player.m_20183_());
        if (this.conditions.getWeathers().size() > 0) {
            if (this.conditions.getWeathers().contains((Object)Weather.THUNDER) && level.m_46470_()) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.RAIN) && level.m_46471_()) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.SNOW) && level.m_46471_() && precipitation == Biome.Precipitation.SNOW) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.BIOME_RAIN) && level.m_46471_() && precipitation == Biome.Precipitation.RAIN) {
                return true;
            }
            return this.conditions.getWeathers().contains((Object)Weather.CLEAR) && !level.m_46471_() && !level.m_46470_();
        }
        return true;
    }

    public abstract SkyboxType<? extends AbstractSkybox> getType();

    public void renderDecorations(WorldRendererAccess levelRendererAccess, PoseStack matrices, Matrix4f matrix4f, float tickDelta, BufferBuilder bufferBuilder, float alpha) {
        RenderSystem.enableBlend();
        Vector3f rotationStatic = this.decorations.getRotation().getStatic();
        Vector3f rotationAxis = this.decorations.getRotation().getAxis();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        this.decorations.getBlend().applyBlendFunc(alpha);
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationAxis.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationAxis.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationAxis.z()));
        double timeRotationX = Utils.calculateRotation(this.decorations.getRotation().getRotationSpeedX(), this.decorations.getRotation().getTimeShift().x(), this.decorations.getRotation().getSkyboxRotation(), level);
        double timeRotationY = Utils.calculateRotation(this.decorations.getRotation().getRotationSpeedY(), this.decorations.getRotation().getTimeShift().y(), this.decorations.getRotation().getSkyboxRotation(), level);
        double timeRotationZ = Utils.calculateRotation(this.decorations.getRotation().getRotationSpeedZ(), this.decorations.getRotation().getTimeShift().z(), this.decorations.getRotation().getSkyboxRotation(), level);
        matrices.m_252781_(Axis.f_252529_.m_252977_((float)timeRotationX));
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)timeRotationY));
        matrices.m_252781_(Axis.f_252403_.m_252977_((float)timeRotationZ));
        matrices.m_252781_(Axis.f_252393_.m_252977_(rotationAxis.z()));
        matrices.m_252781_(Axis.f_252392_.m_252977_(rotationAxis.y()));
        matrices.m_252781_(Axis.f_252495_.m_252977_(rotationAxis.x()));
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationStatic.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationStatic.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationStatic.z()));
        Matrix4f matrix4f2 = matrices.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        if (this.decorations.isSunEnabled()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.decorations.getSunTexture());
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f2, -30.0f, 100.0f, -30.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, 30.0f, 100.0f, -30.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, 30.0f, 100.0f, 30.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, -30.0f, 100.0f, 30.0f).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        if (this.decorations.isMoonEnabled()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.decorations.getMoonTexture());
            int moonPhase = level.m_46941_();
            int xCoord = moonPhase % 4;
            int yCoord = moonPhase / 4 % 2;
            float startX = (float)xCoord / 4.0f;
            float startY = (float)yCoord / 2.0f;
            float endX = (float)(xCoord + 1) / 4.0f;
            float endY = (float)(yCoord + 1) / 2.0f;
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f2, -20.0f, -100.0f, 20.0f).m_7421_(endX, endY).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, 20.0f, -100.0f, 20.0f).m_7421_(startX, endY).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, 20.0f, -100.0f, -20.0f).m_7421_(startX, startY).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, -20.0f, -100.0f, -20.0f).m_7421_(endX, startY).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        if (this.decorations.isStarsEnabled()) {
            float i = 1.0f - level.m_46722_(tickDelta);
            float brightness = level.m_104811_(tickDelta) * i;
            if (brightness > 0.0f) {
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)brightness);
                FogRenderer.m_109017_();
                levelRendererAccess.getStarsBuffer().m_85921_();
                levelRendererAccess.getStarsBuffer().m_253207_(matrices.m_85850_().m_252922_(), matrix4f, GameRenderer.m_172808_());
                VertexBuffer.m_85931_();
            }
        }
        matrices.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public Decorations getDecorations() {
        return this.decorations;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getPriority() {
        return this.properties.getPriority();
    }

    @Override
    public boolean isActive() {
        return this.getAlpha() != 0.0f;
    }
}

