/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.config;

import com.foopy.forgeskyboxes.FabricSkyBoxesClient;
import com.foopy.forgeskyboxes.SkyboxManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FabricSkyBoxesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final GeneralSettings generalSettings = new GeneralSettings();
    private final KeyBindingImpl keyBinding = new KeyBindingImpl();
    private File file;

    public static FabricSkyBoxesConfig load(File file) {
        FabricSkyBoxesConfig config;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (FabricSkyBoxesConfig)GSON.fromJson((Reader)reader, FabricSkyBoxesConfig.class);
            }
            catch (Exception e) {
                FabricSkyBoxesClient.getLogger().error("Could not parse config, falling back to defaults!", (Throwable)e);
                config = new FabricSkyBoxesConfig();
            }
        } else {
            config = new FabricSkyBoxesConfig();
        }
        config.file = file;
        config.save();
        return config;
    }

    public KeyBindingImpl getKeyBinding() {
        return this.keyBinding;
    }

    public void save() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class GeneralSettings {
        public boolean enable = true;
        public int unexpectedTransitionDuration = 20;
        public boolean keepVanillaBehaviour = true;
        public boolean debugMode = false;
        public boolean debugHud = false;
    }

    public static class KeyBindingImpl {
        public final KeyMapping toggleFabricSkyBoxes = new KeyMapping("key.forgeskyboxes.toggle", InputConstants.Type.KEYSYM, -1, "category.forgeskyboxes");
        public final KeyMapping toggleSkyboxDebugHud = new KeyMapping("key.forgeskyboxes.toggle.debug_hud", InputConstants.Type.KEYSYM, 301, "category.forgeskyboxes");

        @SubscribeEvent
        public void onEndTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            while (this.toggleFabricSkyBoxes.m_90859_()) {
                FabricSkyBoxesClient.config().generalSettings.enable = !FabricSkyBoxesClient.config().generalSettings.enable;
                FabricSkyBoxesClient.config().save();
                SkyboxManager.getInstance().setEnabled(FabricSkyBoxesClient.config().generalSettings.enable);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                assert (player != null);
                if (SkyboxManager.getInstance().isEnabled()) {
                    player.m_213846_((Component)Component.m_237115_((String)"forgeskyboxes.message.enabled"));
                    continue;
                }
                player.m_213846_((Component)Component.m_237115_((String)"forgeskyboxes.message.disabled"));
            }
            while (this.toggleSkyboxDebugHud.m_90859_()) {
                FabricSkyBoxesClient.config().generalSettings.debugHud = !FabricSkyBoxesClient.config().generalSettings.debugHud;
                FabricSkyBoxesClient.config().save();
            }
        }
    }
}

