/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes;

import com.foopy.forgeskyboxes.FabricSkyBoxesClient;
import com.foopy.forgeskyboxes.api.FabricSkyBoxesApi;
import com.foopy.forgeskyboxes.api.skyboxes.Skybox;
import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import com.foopy.forgeskyboxes.util.JsonObjectWrapper;
import com.foopy.forgeskyboxes.util.object.internal.Metadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class SkyboxManager
implements FabricSkyBoxesApi {
    private static final SkyboxManager INSTANCE = new SkyboxManager();
    private final Map<ResourceLocation, Skybox> skyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final Map<ResourceLocation, Skybox> permanentSkyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final List<Skybox> activeSkyboxes = new LinkedList<Skybox>();
    private final Predicate<? super Skybox> renderPredicate = skybox -> !this.activeSkyboxes.contains(skybox) && skybox.isActive();
    private Skybox currentSkybox = null;
    private boolean enabled = true;

    public static AbstractSkybox parseSkyboxJson(ResourceLocation id, JsonObjectWrapper objectWrapper) {
        Object skybox;
        Metadata metadata;
        try {
            metadata = (Metadata)((Pair)Metadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)objectWrapper.getFocusedObject()).getOrThrow(false, System.err::println)).getFirst();
        }
        catch (RuntimeException e) {
            FabricSkyBoxesClient.getLogger().warn("Skipping invalid skybox " + id.toString(), (Throwable)e);
            FabricSkyBoxesClient.getLogger().warn(objectWrapper.toString());
            return null;
        }
        SkyboxType type = (SkyboxType)SkyboxType.REGISTRY.get().getValue(metadata.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown skybox type: " + metadata.getType().m_135815_().replace('_', '-')));
        if (metadata.getSchemaVersion() == 1) {
            Preconditions.checkArgument((boolean)type.isLegacySupported(), (Object)("Unsupported schema version '1' for skybox type " + type.getName()));
            FabricSkyBoxesClient.getLogger().debug("Using legacy deserializer for skybox " + id.toString());
            skybox = type.instantiate();
            type.getDeserializer().getDeserializer().accept(objectWrapper, (AbstractSkybox)skybox);
        } else {
            skybox = (AbstractSkybox)((Pair)type.getCodec(metadata.getSchemaVersion()).decode((DynamicOps)JsonOps.INSTANCE, (Object)objectWrapper.getFocusedObject()).getOrThrow(false, System.err::println)).getFirst();
        }
        return skybox;
    }

    public static SkyboxManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void addSkybox(ResourceLocation ResourceLocation2, JsonObject jsonObject) {
        AbstractSkybox skybox = SkyboxManager.parseSkyboxJson(ResourceLocation2, new JsonObjectWrapper(jsonObject));
        if (skybox != null) {
            this.addSkybox(ResourceLocation2, skybox);
        }
    }

    @Override
    public void addSkybox(ResourceLocation ResourceLocation2, Skybox skybox) {
        Preconditions.checkNotNull((Object)ResourceLocation2, (Object)"ResourceLocation was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        this.skyboxMap.put(ResourceLocation2, skybox);
        this.sortSkybox();
    }

    private void sortSkybox() {
        Map newSortedMap = (Map)this.skyboxMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Skybox::getPriority))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (skybox, skybox2) -> skybox, Object2ObjectLinkedOpenHashMap::new));
        this.skyboxMap.clear();
        this.skyboxMap.putAll(newSortedMap);
    }

    @Override
    public void addPermanentSkybox(ResourceLocation ResourceLocation2, Skybox skybox) {
        Preconditions.checkNotNull((Object)ResourceLocation2, (Object)"ResourceLocation was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        this.permanentSkyboxMap.put(ResourceLocation2, skybox);
    }

    @Override
    @ApiStatus.Internal
    public void clearSkyboxes() {
        this.skyboxMap.clear();
        this.activeSkyboxes.clear();
    }

    @ApiStatus.Internal
    public void renderSkyboxes(WorldRendererAccess worldRendererAccess, PoseStack matrices, Matrix4f matrix4f, float tickDelta, Camera camera, boolean thickFog) {
        this.activeSkyboxes.forEach(skybox -> {
            this.currentSkybox = skybox;
            skybox.render(worldRendererAccess, matrices, matrix4f, tickDelta, camera, thickFog);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Skybox getCurrentSkybox() {
        return this.currentSkybox;
    }

    @Override
    public int getApiVersion() {
        return 0;
    }

    @Override
    public List<Skybox> getActiveSkyboxes() {
        return this.activeSkyboxes;
    }

    @SubscribeEvent
    public void onEndTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side.isServer()) {
            return;
        }
        ClientLevel client = Minecraft.m_91087_().f_91073_;
        StreamSupport.stream(Iterables.concat(this.skyboxMap.values(), this.permanentSkyboxMap.values()).spliterator(), false).forEach(skybox -> skybox.tick(client));
        this.activeSkyboxes.removeIf(skybox -> !skybox.isActive());
        this.skyboxMap.values().stream().filter(this.renderPredicate).forEach(this.activeSkyboxes::add);
        this.permanentSkyboxMap.values().stream().filter(this.renderPredicate).forEach(this.activeSkyboxes::add);
        this.activeSkyboxes.sort(Comparator.comparingInt(Skybox::getPriority));
    }

    public Map<ResourceLocation, Skybox> getSkyboxMap() {
        return this.skyboxMap;
    }
}

