/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes;

import com.foopy.forgeskyboxes.SkyboxManager;
import com.foopy.forgeskyboxes.config.FabricSkyBoxesConfig;
import com.foopy.forgeskyboxes.config.SkyBoxDebugScreen;
import com.foopy.forgeskyboxes.resource.SkyboxResourceListener;
import com.foopy.forgeskyboxes.skyboxes.LegacyDeserializer;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="forgeskyboxes")
public class FabricSkyBoxesClient {
    public static final String MODID = "forgeskyboxes";
    private static Logger LOGGER;
    private static FabricSkyBoxesConfig CONFIG;

    public static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = LogManager.getLogger((String)"ForgeSkyboxes");
        }
        return LOGGER;
    }

    public static FabricSkyBoxesConfig config() {
        if (CONFIG == null) {
            CONFIG = FabricSkyBoxesClient.loadConfig();
        }
        return CONFIG;
    }

    private static FabricSkyBoxesConfig loadConfig() {
        return FabricSkyBoxesConfig.load(FMLPaths.CONFIGDIR.get().resolve("forgeskyboxes-config.json").toFile());
    }

    public FabricSkyBoxesClient() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SkyboxType.SKYBOX_TYPE.register(bus);
        LegacyDeserializer.DESERIALIZER.register(bus);
        bus.addListener(this::onInitializeClient);
        bus.addListener(this::registerBindings);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        SkyboxType.initRegistry();
        SkyboxManager.getInstance().setEnabled(FabricSkyBoxesClient.config().generalSettings.enable);
        ReloadableResourceManager resourceManager = (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        resourceManager.m_7217_((PreparableReloadListener)new SkyboxResourceListener());
        MinecraftForge.EVENT_BUS.register((Object)SkyboxManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)FabricSkyBoxesClient.config().getKeyBinding());
        SkyBoxDebugScreen screen = new SkyBoxDebugScreen((Component)Component.m_237113_((String)"Skybox Debug Screen"));
        MinecraftForge.EVENT_BUS.register((Object)screen);
        Minecraft.m_91087_().m_91391_();
    }

    public void registerBindings(RegisterKeyMappingsEvent event) {
        FabricSkyBoxesConfig.KeyBindingImpl keyMappings = FabricSkyBoxesClient.config().getKeyBinding();
        event.register(keyMappings.toggleFabricSkyBoxes);
        event.register(keyMappings.toggleSkyboxDebugHud);
    }
}

