/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;

public interface EMFAnimationApi {
    public static int getApiVersion() {
        return 4;
    }

    @Nullable
    public static EMFEntity getCurrentEntity() {
        return EMFAnimationEntityContext.getEMFEntity();
    }

    public static void registerSingletonAnimationVariable(String sourceModId, String variableName, String variableExplanationTranslationKeyOrText, BooleanSupplier variableValueSupplier) {
        if (sourceModId != null && variableName != null && variableValueSupplier != null && variableExplanationTranslationKeyOrText != null) {
            VariableRegistry.getInstance().registerSimpleBoolVariable(variableName, variableExplanationTranslationKeyOrText, variableValueSupplier);
            EMFUtils.log("Successful registration of singleton variable:" + variableName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of singleton variable:" + variableName + " from mod " + sourceModId);
        }
    }

    public static void registerSingletonAnimationVariable(String sourceModId, String variableName, String variableExplanationTranslationKeyOrText, SampledFloat variableValueSupplier) {
        if (sourceModId != null && variableName != null && variableValueSupplier != null && variableExplanationTranslationKeyOrText != null) {
            VariableRegistry.getInstance().registerSimpleFloatVariable(variableName, variableExplanationTranslationKeyOrText, (MathValue.ResultSupplier)variableValueSupplier);
            EMFUtils.log("Successful registration of singleton variable:" + variableName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of singleton variable:" + variableName + " from mod " + sourceModId);
        }
    }

    public static void registerUniqueAnimationVariableFactory(String sourceModId, String variableName, UniqueVariableFactory uniqueVariableFactory) {
        if (sourceModId != null && variableName != null && uniqueVariableFactory != null) {
            VariableRegistry.getInstance().registerContextVariable(uniqueVariableFactory);
            EMFUtils.log("Successful registration of unique variable:" + variableName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of unique variable:" + variableName + " from mod " + sourceModId);
        }
    }

    public static void registerAnimationFunction(String sourceModId, String methodName, String methodExplanationTranslationKeyOrText, Function<Float, Float> function) {
        if (sourceModId != null && methodName != null && function != null && methodExplanationTranslationKeyOrText != null) {
            MethodRegistry.getInstance().registerSimpleMethodFactory(methodName, methodExplanationTranslationKeyOrText, function);
            EMFUtils.log("Successful registration of function:" + methodName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of function:" + methodName + " from mod " + sourceModId);
        }
    }

    public static void registerAnimationBiFunction(String sourceModId, String methodName, String methodExplanationTranslationKeyOrText, BiFunction<Float, Float, Float> biFunction) {
        if (sourceModId != null && methodName != null && biFunction != null && methodExplanationTranslationKeyOrText != null) {
            MethodRegistry.getInstance().registerSimpleMethodFactory(methodName, methodExplanationTranslationKeyOrText, biFunction);
            EMFUtils.log("Successful registration of bifunction:" + methodName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of bifunction:" + methodName + " from mod " + sourceModId);
        }
    }

    public static void registerAnimationTriFunction(String sourceModId, String methodName, String methodExplanationTranslationKeyOrText, TriFunction<Float, Float, Float, Float> triFunction) {
        if (sourceModId != null && methodName != null && triFunction != null && methodExplanationTranslationKeyOrText != null) {
            MethodRegistry.getInstance().registerSimpleMethodFactory(methodName, methodExplanationTranslationKeyOrText, triFunction);
            EMFUtils.log("Successful registration of trifunction:" + methodName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of trifunction:" + methodName + " from mod " + sourceModId);
        }
    }

    public static void registerAnimationMultiFunction(String sourceModId, String methodName, String methodExplanationTranslationKeyOrText, Function<List<Float>, Float> multiFunction) {
        if (sourceModId != null && methodName != null && multiFunction != null && methodExplanationTranslationKeyOrText != null) {
            MethodRegistry.getInstance().registerSimpleMultiMethodFactory(methodName, methodExplanationTranslationKeyOrText, multiFunction);
            EMFUtils.log("Successful registration of multifunction:" + methodName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of multifunction:" + methodName + " from mod " + sourceModId);
        }
    }

    public static void registerCustomFunctionFactory(String sourceModId, String methodName, String methodExplanationTranslationKeyOrText, MethodRegistry.MethodFactory factory) {
        if (sourceModId != null && methodName != null && factory != null && methodExplanationTranslationKeyOrText != null) {
            MethodRegistry.getInstance().registerAndWrapMethodFactory(methodName, methodExplanationTranslationKeyOrText, factory);
            EMFUtils.log("Successful registration of custom function:" + methodName + " from mod " + sourceModId);
        } else {
            EMFUtils.logError("Invalid registration of custom function:" + methodName + " from mod " + sourceModId);
        }
    }

    public static EMFEntity emfEntityOf(Entity entity) {
        return (EMFEntity)entity;
    }

    public static EMFEntity emfEntityOf(BlockEntity blockEntity) {
        return (EMFEntity)blockEntity;
    }

    public static boolean pauseAllCustomAnimationsForEntity(EMFEntity entityOrBlockEntity) {
        if (entityOrBlockEntity == null || entityOrBlockEntity.etf$getUuid() == null) {
            return false;
        }
        EMFAnimationEntityContext.entitiesPaused.add((Object)entityOrBlockEntity.etf$getUuid());
        return true;
    }

    public static boolean resumeAllCustomAnimationsForEntity(EMFEntity entityOrBlockEntity) {
        if (entityOrBlockEntity == null || entityOrBlockEntity.etf$getUuid() == null) {
            return false;
        }
        EMFAnimationEntityContext.entitiesPaused.remove((Object)entityOrBlockEntity.etf$getUuid());
        EMFAnimationEntityContext.entitiesPausedParts.remove((Object)entityOrBlockEntity.etf$getUuid());
        return true;
    }

    public static boolean pauseCustomAnimationsForThesePartsOfEntity(EMFEntity entityOrBlockEntity, ModelPart ... parts) {
        if (entityOrBlockEntity == null || entityOrBlockEntity.etf$getUuid() == null || parts == null || parts.length == 0) {
            return false;
        }
        EMFAnimationEntityContext.entitiesPausedParts.put((Object)entityOrBlockEntity.etf$getUuid(), (Object)parts);
        return true;
    }

    public static boolean lockEntityToVanillaModel(EMFEntity entityOrBlockEntity) {
        if (entityOrBlockEntity == null || entityOrBlockEntity.etf$getUuid() == null) {
            return false;
        }
        EMFAnimationEntityContext.entitiesToForceVanillaModel.add((Object)entityOrBlockEntity.etf$getUuid());
        return true;
    }

    public static boolean unlockEntityToVanillaModel(EMFEntity entityOrBlockEntity) {
        if (entityOrBlockEntity == null || entityOrBlockEntity.etf$getUuid() == null) {
            return false;
        }
        EMFAnimationEntityContext.entitiesToForceVanillaModel.remove((Object)entityOrBlockEntity.etf$getUuid());
        return true;
    }

    public static int getCurrentEMFVariantOfModel(EntityModel<?> model) {
        if (!EMFAnimationApi.isModelCustomizedByEMF(model)) {
            return -1;
        }
        return ((IEMFModel)model).emf$getEMFRootModel().currentModelVariant;
    }

    public static boolean isModelAnimatedByEMF(EntityModel<?> model) {
        if (!EMFAnimationApi.isModelCustomizedByEMF(model)) {
            return false;
        }
        return ((IEMFModel)model).emf$getEMFRootModel().hasAnimation();
    }

    public static boolean isModelCustomizedByEMF(EntityModel<?> model) {
        if (model == null) {
            return false;
        }
        return ((IEMFModel)model).emf$isEMFModel();
    }

    public static boolean isModelPartCustomToEMF(ModelPart modelPart) {
        if (modelPart == null) {
            return false;
        }
        return modelPart instanceof EMFModelPartCustom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isModelPartAnimatedByEMF(ModelPart modelPart) {
        if (modelPart == null) {
            return false;
        }
        if (!(modelPart instanceof EMFModelPart)) return false;
        EMFModelPart emf = (EMFModelPart)modelPart;
        if (!emf.isSetByAnimation) return false;
        return true;
    }

    @Deprecated(since="api v2")
    public static void registerSingletonAnimationVariable(String sourceModId, String variableName, BooleanSupplier variableValueSupplier) {
        EMFUtils.logWarn("Invalid registration of singleton variable:" + variableName + " from mod " + sourceModId);
        EMFAnimationApi.registerSingletonAnimationVariable(sourceModId, variableName, variableName, variableValueSupplier);
    }

    @Deprecated(since="api v2")
    public static void registerSingletonAnimationVariable(String sourceModId, String variableName, SampledFloat variableValueSupplier) {
        EMFUtils.logWarn("Invalid registration of singleton variable:" + variableName + " from mod " + sourceModId);
        EMFAnimationApi.registerSingletonAnimationVariable(sourceModId, variableName, variableName, variableValueSupplier);
    }

    @Deprecated(since="api v2")
    public static void registerAnimationFunction(String sourceModId, String methodName, Function<Float, Float> function) {
        EMFUtils.logWarn("Invalid registration of function:" + methodName + " from mod " + sourceModId);
        EMFAnimationApi.registerAnimationFunction(sourceModId, methodName, methodName, function);
    }

    @Deprecated(since="api v2")
    public static void registerAnimationBiFunction(String sourceModId, String methodName, BiFunction<Float, Float, Float> biFunction) {
        EMFUtils.logWarn("Invalid registration of bifunction:" + methodName + " from mod " + sourceModId);
        EMFAnimationApi.registerAnimationBiFunction(sourceModId, methodName, methodName, biFunction);
    }

    @Deprecated(since="api v2")
    public static void registerAnimationTriFunction(String sourceModId, String methodName, TriFunction<Float, Float, Float, Float> triFunction) {
        EMFUtils.logWarn("Invalid registration of trifunction:" + methodName + " from mod " + sourceModId);
        EMFAnimationApi.registerAnimationTriFunction(sourceModId, methodName, methodName, triFunction);
    }

    @Deprecated(since="api v2")
    public static void registerAnimationMultiFunction(String sourceModId, String methodName, Function<List<Float>, Float> multiFunction) {
        EMFUtils.logWarn("Invalid registration of multifunction:" + methodName + " from mod " + sourceModId);
        EMFAnimationApi.registerAnimationMultiFunction(sourceModId, methodName, methodName, multiFunction);
    }

    @Deprecated(since="api v2")
    public static void registerCustomFunctionFactory(String sourceModId, String methodName, MethodRegistry.MethodFactory factory) {
        EMFUtils.logWarn("Invalid registration of custom function:" + methodName + " from mod " + sourceModId);
        EMFAnimationApi.registerCustomFunctionFactory(sourceModId, methodName, methodName, factory);
    }
}

