/*
 * Decompiled with CFR 0.152.
 */
package nya.clockwork04.Minefetch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class NeoParser {
    boolean debug = false;
    ChatColor neocolor;
    private final List<String> neofetch = new ArrayList<String>();
    private final HashMap neomap = new HashMap();

    public boolean init(Plugin plugin) {
        plugin.getLogger().info("Getting initial neofetch (this takes awhile on certain systems, don't worry it only happens during initialization)");
        this.readNeofetch();
        this.parseNeofetch();
        this.distroDetect();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.runTaskTimerAsynchronously(plugin, this::updateNeofetch, 0L, 1200L);
        plugin.getLogger().info("NeoParser Initialized! Nya~ >w<");
        return true;
    }

    private void distroDetect() {
        String distroString = this.neomap.get("OS").toString();
        String mintRegex = "Arch";
        String redRegex = "Debian";
        String purpleRegex = "Gentoo";
        this.neocolor = distroString.contains(mintRegex) ? ChatColor.AQUA : (distroString.contains(redRegex) ? ChatColor.RED : (distroString.contains(purpleRegex) ? ChatColor.DARK_PURPLE : ChatColor.BLUE));
    }

    public ChatColor getNeocolor() {
        return this.neocolor;
    }

    public void updateNeofetch() {
        this.readNeofetch();
        this.parseNeofetch();
    }

    public void readNeofetch() {
        try {
            String line;
            this.neofetch.clear();
            Process process = Runtime.getRuntime().exec("neofetch --off --stdout");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (this.debug) {
                    Bukkit.getLogger().info(line);
                }
                this.neofetch.add(line);
            }
            if (this.debug) {
                Bukkit.getLogger().info("Neofetch Read!");
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public void parseNeofetch() {
        this.neomap.clear();
        this.neomap.put("hostname", this.neofetch.get(0));
        for (String outputLine : this.neofetch) {
            int colonIndex = outputLine.indexOf(":");
            if (colonIndex == -1) continue;
            String key = outputLine.substring(0, colonIndex).trim();
            String value = outputLine.substring(colonIndex + 1).trim();
            this.neomap.put(key, value);
        }
        if (this.debug) {
            Bukkit.getLogger().info("Neofetch Parsed!");
        }
    }

    public String getNeofetch(String value) {
        return this.neomap.get(value).toString();
    }
}

