/*
 * Decompiled with CFR 0.152.
 */
package nya.clockwork04.Minefetch;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import nya.clockwork04.Minefetch.Loadometer;
import nya.clockwork04.Minefetch.NeoParser;
import nya.clockwork04.Minefetch.TPS;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private NeoParser neofetch;
    private Loadometer load;

    @Override
    public void onEnable() {
        this.neofetch = new NeoParser();
        if (!this.neofetch.init(this)) {
            this.getLogger().severe("NeoParser Failed to Initialize! Is Neofetch installed?");
            Bukkit.getPluginManager().disablePlugin(this);
            return;
        }
        this.load = new Loadometer();
        if (!this.load.init(this)) {
            this.getLogger().severe("Loadometer Failed to Initialize!");
            Bukkit.getPluginManager().disablePlugin(this);
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("neofetch")) {
            if (this.neofetch.getNeofetch("OS") == null) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Neofetch Failed!");
                this.getLogger().severe("Neofetch Failed, called by: " + sender.getName());
                return false;
            }
            OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            double cpuUsage = osBean.getSystemCpuLoad() * 100.0;
            Runtime runtime = Runtime.getRuntime();
            long allocatedMemory = runtime.totalMemory();
            ArrayList<String> MessageQueue = new ArrayList<String>();
            ChatColor neocolor = this.neofetch.getNeocolor();
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "--- %s%s%s---", new Object[]{ChatColor.WHITE, this.neofetch.getNeofetch("hostname"), neocolor}));
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "OS: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("OS"), new Object[0]));
            if (this.neofetch.getNeofetch("Host") != null) {
                MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "Host: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("Host"), new Object[0]));
            }
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "Kernel: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("Kernel"), new Object[0]));
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "CPU: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("CPU") + " (" + Math.round(cpuUsage) + "%%)", new Object[0]));
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "GPU: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("GPU"), new Object[0]));
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "Memory: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("Memory") + " (" + allocatedMemory / 0x100000L + " MiB Allocated)", new Object[0]));
            MessageQueue.add(String.format(String.valueOf((Object)neocolor) + "Uptime: " + String.valueOf((Object)ChatColor.BOLD) + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("Uptime"), new Object[0]));
            String[] array = new String[MessageQueue.size()];
            MessageQueue.toArray(array);
            sender.sendMessage(array);
        }
        if (command.getName().equalsIgnoreCase("loadfetch")) {
            ArrayList<Object> MessageQueue = new ArrayList<Object>();
            String usage = String.valueOf((Object)ChatColor.BOLD) + "USED: ";
            MessageQueue.add(String.format(String.valueOf((Object)ChatColor.BLUE) + "--- %s%s%s---", new Object[]{ChatColor.WHITE, "Loadfetch ", ChatColor.BLUE}));
            MessageQueue.add(String.valueOf((Object)ChatColor.BLUE) + String.valueOf((Object)ChatColor.BOLD) + "CPU: " + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("CPU"));
            MessageQueue.add(String.valueOf((Object)ChatColor.BLUE) + usage + String.valueOf((Object)ChatColor.WHITE) + this.load.barBuilder(this.load.getCPULoad()));
            MessageQueue.add(String.valueOf((Object)ChatColor.BLUE) + String.valueOf((Object)ChatColor.BOLD) + "RAM: " + String.valueOf((Object)ChatColor.WHITE) + this.neofetch.getNeofetch("Memory"));
            MessageQueue.add(String.valueOf((Object)ChatColor.BLUE) + usage + String.valueOf((Object)ChatColor.WHITE) + this.load.barBuilder(this.load.getMEMLoad()) + " (JVM)");
            MessageQueue.add(String.valueOf((Object)ChatColor.BOLD) + "World size: " + String.valueOf((Object)ChatColor.RESET) + Math.round(this.load.getWorldSize()) + " MB");
            double tps = TPS.getTPS();
            DecimalFormat df = new DecimalFormat("0.00");
            ChatColor tpsColor = tps >= 18.0 ? ChatColor.GREEN : (tps <= 13.0 ? ChatColor.RED : ChatColor.YELLOW);
            MessageQueue.add(String.valueOf((Object)ChatColor.BOLD) + "Server TPS: " + String.valueOf((Object)tpsColor) + df.format(tps) + " TPS");
            String[] array = new String[MessageQueue.size()];
            MessageQueue.toArray(array);
            sender.sendMessage(array);
        }
        return true;
    }
}

