/*
 * Decompiled with CFR 0.152.
 */
package nya.clockwork04.Minefetch;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import nya.clockwork04.Minefetch.TPS;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Loadometer {
    private double memUsage;
    private double cpuUsage;
    private double worldSize;
    private boolean worldGrabbed = false;

    public boolean init(Plugin plugin) {
        this.updateLoad();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.runTaskTimerAsynchronously(plugin, this::updateLoad, 0L, 2400L);
        scheduler.runTaskTimerAsynchronously(plugin, this::updateWorldSize, 600L, 1200L);
        scheduler.runTaskTimerAsynchronously(plugin, new TPS(), 100L, 1L);
        return true;
    }

    public void updateLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        this.cpuUsage = osBean.getSystemCpuLoad() * 100.0;
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        this.memUsage = (double)usedMemory / (double)totalMemory * 100.0;
    }

    public void updateWorldSize() {
        double sizeInGB;
        if (!this.worldGrabbed) {
            Bukkit.getLogger().info("[Minefetch] Loading world size for the first time..");
        }
        File worldDirectory = new File(Bukkit.getServer().getWorldContainer(), Bukkit.getServer().getWorlds().get(0).getName());
        long sizeInBytes = this.getDirectorySize(worldDirectory);
        this.worldSize = sizeInGB = (double)sizeInBytes / 1048576.0;
        this.worldGrabbed = true;
    }

    public double getCPULoad() {
        return this.cpuUsage;
    }

    public double getMEMLoad() {
        return this.memUsage;
    }

    public double getWorldSize() {
        if (!this.worldGrabbed) {
            return 0.0;
        }
        return this.worldSize;
    }

    private long getDirectorySize(File directory) {
        long size = 0L;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    size += file.length();
                    continue;
                }
                size += this.getDirectorySize(file);
            }
        }
        return size;
    }

    public String barBuilder(double percentageFree) {
        ChatColor wrapColor = ChatColor.WHITE;
        ChatColor color = ChatColor.GOLD;
        color = percentageFree >= 60.0 ? ChatColor.RED : (percentageFree >= 35.0 ? ChatColor.YELLOW : ChatColor.GREEN);
        Object bar = "";
        int looped = 0;
        while (true) {
            int n = looped++;
            if (!((double)n < percentageFree / 5.0)) break;
            bar = (String)bar + "#";
        }
        bar = (String)bar + String.valueOf((Object)ChatColor.WHITE);
        while (looped++ <= 20) {
            bar = (String)bar + "_";
        }
        return String.valueOf((Object)wrapColor) + "[" + String.valueOf((Object)color) + (String)bar + String.valueOf((Object)wrapColor) + "]  (" + Math.round(percentageFree) + "%)";
    }
}

